/*
 * Decimate stereo                                       v0.10
 * Does not work with 16-bit yet
 * by Royce Liao...inspired by LEARN C NOW sample code (C) Microsoft Press
 * Count the number of characters in a file.  CHARCNT
 * correctly handles only ASCII text files.
 */

#include <\work\lc\include\stdio.h>
#include <\work\lc\include\stdlib.h>     /* for exit() prototype */

#define MAXPATH 64
#define BUF_SIZE 512

main(void)
{
	int loop,n, n_out[2];                 /* input character */
	FILE *fpin, *fpout[2];               /* file pointer */
	char pathname[MAXPATH]; /* filename buffer */
	char outpath[2][MAXPATH+4];
	char in_buffer[BUF_SIZE];
	char out_buffer[2][BUF_SIZE/2];
	char ch[MAXPATH];
	int flag8=-1,
	    flag2=-1, buf_length=BUF_SIZE;
	long length_in=0,
	     length_out=0, skip=0;

	printf("Filename: ");  /* Prompt user for input file name */
	scanf("%s",pathname);

	fpin = fopen(pathname, "rb");
	if (fpin == NULL) {
		fprintf(stderr, "Cannot open %s\n", pathname);
		exit(1);
	}

	for (n=0; n<2; ++n)  {
	   printf("Outpath #%d: ",n);/* Prompt user for output file name */
	   scanf("%s",outpath[n]);
	   fpout[n]=fopen(outpath[n], "wb");
	   }

	/*  NOT IMPLEMENTED YET!!! 16-bit stereo splitter
	do
	{
	   printf("\nConvert to 8-bit or 16-bit (8/16/<n>one) ?");
	   scanf("%s", ch);
	   switch (ch[0]) {
		case '8':
			flag8=8; break;
		case '1':
			flag8=16;
			buf_length/=2;
			break;
		case 'n', 'N':
			flag8=0; break;
		default:
			flag8=-1;
			break;
		}
	}
	while (flag8==-1);        */

	do
	{
	    printf("\nSwitch between 2's complement & unsigned (y/n) ? ");
	    scanf("%s", ch);
	    switch (ch[0]) {
		case 'y': case 'Y':
		     flag2=1;                break;
		case 'n': case 'N':
		     flag2=0;                break;
		default:
		     break;  }
	}
	while (flag2==-1);


	printf("\nSkip how many byte(s) or 0 ? ");
	scanf("%ld", &skip);
	if (skip!=0)
	   if ( fseek(fpin, skip, SEEK_SET) != 0 )
	      printf("\nWARNING! Could not seek %ld!",skip);
	     else
	      length_in+=skip;  /* Precompensate for offset */
	      /* from beginning of file fpin */


	/*
	 * Read the contents of the file and increment the
	 * character count as each character is read.
	 */

	do      {
		n=fread(in_buffer,sizeof(char),buf_length,fpin);
		length_in+=n;
		n_out[0]=n_out[1]=n;

		if (flag2==1)
		   for (loop=0; loop<n; ++loop)
		       in_buffer[loop]-=128;

		for (loop=0; loop<n; loop+=2)  {
		    out_buffer[0][loop/2]=in_buffer[loop];
		    out_buffer[1][loop/2]=in_buffer[loop+1];
		    }

		n_out[0]=n_out[1]=n/2;
		if (n/2!=(int)(n/2.0+0.4))
		   n_out[1]-=1;

    length_out+=fwrite(out_buffer[0],sizeof(char),n_out[0],fpout[0])+
		fwrite(out_buffer[1],sizeof(char),n_out[1],fpout[1]);
		}

	while (n==BUF_SIZE);

	if (ferror(fpin) != 0) {
		fprintf(stderr, "Error reading %s\n", pathname);
		exit(2);
	}

	/*
	 * Report the filename and character count
	 * and close the file.
	 */
	printf("\nFile %s contains %ld characters.\n",
		pathname, length_in);
	printf("\nTogether, %s and %s contain",outpath[0],outpath[1]);
	printf("\n%ld characters.", length_out);
	if (fclose(fpin) != 0) {
		fprintf(stderr, "Error closing %s\n",
			pathname);
		exit(3);
	}

	for (n=0; n<2; ++n)
	    if (fclose(fpout[n]) !=0) {
		fprintf(stderr, "Error closing %s\n",
			outpath[n]);
		exit(3);
	    }

	return (0);
}
